local tChoices = {};
for i=1,10  do
tChoices[i] = i-1;
end;

local BGChoice = {};
for i=1,11  do
BGChoice[i] = (i-1)*10;
end;

function PlayerOptionsJ()
	local pm = GAMESTATE:GetPlayMode();
	local restricted = { PlayMode_Oni= true, PlayMode_Rave= true,
		--"PlayMode_Battle" -- ??
	};
	local optionsScreen = "ScreenPlayerOptionsJ";
	if restricted[pm] then
		optionsScreen = "ScreenPlayerOptionsRestricted";
	end
	if SCREENMAN:GetTopScreen():GetGoToOptions() then
		return optionsScreen;
	else
		return "ScreenStageInformation";
	end;
end;

function PlayerOptionNext()
	local t = {
		Name = "PlayerOptionNext";
		LayoutType = "ShowAllInRow";
		SelectType = "SelectOne";
		OneChoiceForAllPlayers = false;
		ExportOnChange = false;
		Choices = { 'Play','Back' };		
		LoadSelections = function(self, list, pn)
		end;
		SaveSelections = function(self, list, pn)
			if list[2] then
				SCREENMAN:GetTopScreen():SetNextScreenName(Branch.BackOutOfPlayerOptions());
			end;
		end;
	};
	return t;
end;

function SpeedDisplay()
	local t = {
		Name = "SpeedDisplay";
		LayoutType = "ShowOneInRow";
		SelectType = "SelectOne";
		OneChoiceForAllPlayers = false;
		ExportOnChange = true;
		Choices = { 'C','X','A','CX','M' };
		LoadSelections = function(self, list, pn)
			local pName = ToEnumShortString(pn)
			if ReadPrefFromFile("SpeedDisplay"..pName) ~= nil then
			if GetUserPref("SpeedDisplay"..pName) == "5" then
					list[5] = true;
				elseif GetUserPref("SpeedDisplay"..pName) == "4" then
					list[4] = true;
				elseif GetUserPref("SpeedDisplay"..pName) == "3" then
					list[3] = true;
				elseif GetUserPref("SpeedDisplay"..pName) == "2" then
					list[2] = true;
				else
					list[1] = true;
				end;
			else
				WritePrefToFile("SpeedDisplay"..pName,"1");
				list[1] = true;
			end;
		end;
		SaveSelections = function(self, list, pn)
			local val;
			local pName = ToEnumShortString(pn)
			if list[5] then
				val = "5";
			elseif list[4] then
				val = "4";
			elseif list[3] then
				val = "3";
			elseif list[2] then
				val = "2";
			else
				val = "1";
			end;
			WritePrefToFile("SpeedDisplay"..pName,val);
			MESSAGEMAN:Broadcast("PreferenceSet", { Message == "Set Preference" } );
			--THEME:ReloadMetrics();
		end;
	};
	setmetatable( t, t );
	return t;
end	

function BackgroundFilter()
	local t = {
		Name = "BackgroundFilter";
		LayoutType = "ShowAllInRow";
		SelectType = "SelectOne";
		OneChoiceForAllPlayers = false;
		ExportOnChange = true;
		Choices = BGChoice;
		LoadSelections = function(self, list, pn)
			local pName = ToEnumShortString(pn)
			if ReadPrefFromFile("BackgroundFilter"..pName) ~= nil then
				local loadval = GetUserPrefN("BackgroundFilter"..pName)+1;
				list[loadval] = true;
			else
				WritePrefToFile("BackgroundFilter"..pName,"1");
				list[1] = true;
			end;
		end;
		SaveSelections = function(self, list, pn)
			local found = false
			for i=1,#list do
				if not found then
					if list[i] == true then
						local val = i-1;
						local pName = ToEnumShortString(pn)
						WritePrefToFile("BackgroundFilter"..pName,val);
						found = true
					end
				end
			end
			MESSAGEMAN:Broadcast("PreferenceSet", { Message == "Set Preference" } );
		end;
	};
	setmetatable( t, t );
	return t;
end;

function SpeedMod1()
	local t = {
		Name = "SpeedMod";
		LayoutType = "ShowAllInRow";
		SelectType = "SelectOne";
		OneChoiceForAllPlayers = false;
		ExportOnChange = true;
		Choices = tChoices;
		LoadSelections = function(self, list, pn)
			local pName = ToEnumShortString(pn)
			if ReadPrefFromFile("SpeedMod1"..pName) ~= nil then
				local loadval = GetUserPrefN("SpeedMod1"..pName)+1;
				list[loadval] = true;
			else
				WritePrefToFile("SpeedMod1"..pName,"1");
				list[1] = true;
			end;
		end;
		SaveSelections = function(self, list, pn)
			local found = false
			for i=1,#list do
				if not found then
					if list[i] == true then
						local val = i-1;
						local pName = ToEnumShortString(pn)
						WritePrefToFile("SpeedMod1"..pName,val);
						found = true
					end
				end
			end
			MESSAGEMAN:Broadcast("PreferenceSet", { Message == "Set Preference" } );
		end;
	};
	setmetatable( t, t );
	return t;
end;

function SpeedMod2()
	local t = {
		Name = "SpeedMod";
		LayoutType = "ShowAllInRow";
		SelectType = "SelectOne";
		OneChoiceForAllPlayers = false;
		ExportOnChange = true;
		Choices = tChoices;
		LoadSelections = function(self, list, pn)
			local pName = ToEnumShortString(pn)
			if ReadPrefFromFile("SpeedMod2"..pName) ~= nil then
				local loadval = GetUserPrefN("SpeedMod2"..pName)+1;
				list[loadval] = true;
			else
				WritePrefToFile("SpeedMod2"..pName,"1");
				list[1] = true;
			end;
		end;
		SaveSelections = function(self, list, pn)
			local found = false
			for i=1,#list do
				if not found then
					if list[i] == true then
						local val = i-1;
						local pName = ToEnumShortString(pn)
						WritePrefToFile("SpeedMod2"..pName,val);
						found = true
					end
				end
			end
			MESSAGEMAN:Broadcast("PreferenceSet", { Message == "Set Preference" } );
		end;
	};
	setmetatable( t, t );
	return t;
end;

function SpeedMod3()
	local t = {
		Name = "SpeedMod";
		LayoutType = "ShowAllInRow";
		SelectType = "SelectOne";
		OneChoiceForAllPlayers = false;
		ExportOnChange = true;
		Choices = tChoices;
		LoadSelections = function(self, list, pn)
			local pName = ToEnumShortString(pn)
			if ReadPrefFromFile("SpeedMod3"..pName) ~= nil then
				local loadval = GetUserPrefN("SpeedMod3"..pName)+1;
				list[loadval] = true;
			else
				WritePrefToFile("SpeedMod3"..pName,"1");
				list[1] = true;
			end;
		end;
		SaveSelections = function(self, list, pn)
			local found = false
			for i=1,#list do
				if not found then
					if list[i] == true then
						local val = i-1;
						local pName = ToEnumShortString(pn)
						WritePrefToFile("SpeedMod3"..pName,val);
						found = true
					end
				end
			end
			MESSAGEMAN:Broadcast("PreferenceSet", { Message == "Set Preference" } );
		end;
	};
	setmetatable( t, t );
	return t;
end;